// $Id: CSystemString.cpp,v 1.6 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CSystemString.hpp"
using Exponent::Basics::CSystemString;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CSystemString, CCountedObject);

//	===========================================================================
#ifdef WIN32
	const char *CSystemString::CSYSTEM_STRING_SYSTEM_SEPERATOR = "\\";
#else
	const char *CSystemString::CSYSTEM_STRING_SYSTEM_SEPERATOR = "/";
#endif


//	===========================================================================
CSystemString::CSystemString(const char *string) : CString(string)
{
	EXPONENT_CLASS_CONSTRUCTION(CSystemString);
	// Nothing to do
}

//	===========================================================================
CSystemString::CSystemString(const CString &string) : CString(string)
{
	EXPONENT_CLASS_CONSTRUCTION(CSystemString);
	// Nothing to do
}

//	===========================================================================
CSystemString::CSystemString(const CSystemString &string) : CString(string.getString())
{
	EXPONENT_CLASS_CONSTRUCTION(CSystemString);
	// Nothing to do
}

//	===========================================================================
CSystemString::~CSystemString()
{
	EXPONENT_CLASS_DESTRUCTION(CSystemString);
	// Nothing to do
}

//  ===========================================================================
CSystemString &CSystemString::operator = (const CSystemString &string)
{
	if (this != &string)
	{
		this->setString(string);
	}
	return (*this);
}

//  ===========================================================================
CSystemString &CSystemString::operator = (const char *string)
{
	this->setString(string);
	return (*this);
}

//  ===========================================================================
CSystemString &CSystemString::operator += (const CString &string)
{
	this->appendSystemSeperator();
	this->appendString(string);
	return (*this);
}

//  ===========================================================================
CSystemString &CSystemString::operator += (const char *string)
{
	this->appendSystemSeperator();
	this->appendString(string);
	return (*this);
}

//  ===========================================================================
bool CSystemString::operator == (const char *equals)
{
	return (!strcmp(m_string, equals));
}

//  ===========================================================================
bool CSystemString::operator == (CSystemString &string)
{
	return (!strcmp(m_string, string.getString()));
}

//  ===========================================================================
bool CSystemString::operator != (const char *string)
{
	return (!(*this == string));
}

//  ===========================================================================
bool CSystemString::operator != (CSystemString &string)
{
	return (!(*this == string));
}

//  ===========================================================================
bool CSystemString::operator ! ()
{
	return (m_numberOfCharacters == 0);
}

//  ===========================================================================
char CSystemString::operator [] (const long index)
{
	return this->characterAt(index);
}

//	===========================================================================
bool CSystemString::hasExtension() const
{
	long end = m_numberOfCharacters - 2;
	while(end >= 0 && m_string[end] != '.')
		--end;

	if (end > 0)
	{
		return true;
	}

	return false;
}

//	===========================================================================
bool CSystemString::hasExtension(const char *ext) const
{
	long extensionLength = (long)strlen(ext) - 1;
	long end = m_numberOfCharacters - 2;

	bool valid = true;

	if (extensionLength <= end)
	{
		while(extensionLength >= 0 && valid)
		{
			if (ext[extensionLength] == m_string[end])
			{
				--extensionLength;
				--end;
			}
			else
			{
				valid = false;
			}
		}
	}
	return valid;
}

//	===========================================================================
bool CSystemString::hasExtension(const CString &ext) const
{
	return this->hasExtension(ext.getString());
}

//	===========================================================================
void CSystemString::appendNewExtension(const char *ext, const bool removeOld)
{
	if (!this->hasExtension())
	{
		this->appendString(".");
		this->appendString(ext);
	}
	else
	{
		if (removeOld)
		{
			long end = m_numberOfCharacters - 2;
			while(end >= 0 && m_string[end] != '.')
			{
				--end;
			}

			if (end > 0)
			{
				m_string[end] = '\0';
			}
		}
		this->appendString(".");
		this->appendString(ext);
	}
}

//	===========================================================================
void CSystemString::appendNewExtension(const CString &ext, const bool removeOld)
{
	this->appendNewExtension(ext.getString(), removeOld);
}

//	===========================================================================
void CSystemString::removeExtension()
{
	long end = m_numberOfCharacters - 2;
	while(end >= 0 && m_string[end] != '.')
	{
		--end;
	}

	if (end > 0)
	{
		m_string[end] = '\0';
	}
}

//	===========================================================================
void CSystemString::appendPath(const CString &path)
{
#ifdef WIN32
	if (this->characterAt(this->getNumberOfCharacters() - 2) != '\\')
#else
	if (this->characterAt(this->getNumberOfCharacters() - 2) != '/')
#endif
	{
		this->appendString(CSYSTEM_STRING_SYSTEM_SEPERATOR);
	}
	this->appendString(path);
}

//	===========================================================================
bool CSystemString::isFolder() const
{
	return !hasExtension();
}

//	===========================================================================
void CSystemString::stripFilename()
{
	long end = m_numberOfCharacters - 2;
	while(end >= 0 && m_string[end] != CSYSTEM_STRING_SYSTEM_SEPERATOR[0])
		--end;

	if (end >= 0)
	{
		//char *text = this->getSubString(0, end++);
		//this->setString(text);
		//FREE_ARRAY_POINTER(text);
		this->setString(this->getSubString(0, end++));
	}
}

//	===========================================================================
CString CSystemString::getTheFilename() const
{
	long end = m_numberOfCharacters - 2;
	while(end >= 0 && m_string[end] != CSYSTEM_STRING_SYSTEM_SEPERATOR[0])
		--end;

	if (end >= 0)
	{
		return this->getSubString(++end, m_numberOfCharacters - 1);
	}
	return CString(CString::CSTRING_NULL_STRING);
}

//	===========================================================================
CString CSystemString::getFolderPath()
{
	if (this->isFolder())
	{
		return this->getSubString(0, m_numberOfCharacters);
	}
	else
	{
		long end = m_numberOfCharacters - 2;
		while(end >= 0 && m_string[end] != CSYSTEM_STRING_SYSTEM_SEPERATOR[0])
			--end;

		if (end >= 0)
		{
			return this->getSubString(0, end++);
		}
		return CString(CString::CSTRING_NULL_STRING);
	}
}

//	===========================================================================
void CSystemString::appendSystemSeperator()
{
	this->appendString(CSYSTEM_STRING_SYSTEM_SEPERATOR);
}

//	===========================================================================
CString CSystemString::getDriveLetter(bool withDriveSeperators)
{
	if (!withDriveSeperators)
	{
		char letter[2];
		letter[0] = m_string[0];
		letter[1] = '\0';
		return CString(letter);
	}
	else
	{
		long start = 0;
		while(m_string[start] != CSYSTEM_STRING_SYSTEM_SEPERATOR[0])//_CHAR)
			++start;

		if (start < m_numberOfCharacters)
		{
			return this->getSubString(0, start);
		}
	}
	return CString(CString::CSTRING_NULL_STRING);
}

//	===========================================================================
CString CSystemString::getTheExtension()
{
	long end = m_numberOfCharacters - 2;
	while(end >= 0 && m_string[end] != '.')
		--end;

	if (end >= 0)
	{
		return this->getSubString(end, m_numberOfCharacters);
	}
	return CString(CString::CSTRING_NULL_STRING);
}

//	===========================================================================
long CSystemString::getNumberOfPathComponents()
{
	CStringTokeniser *tokeniser = new CStringTokeniser(CString(m_string), CSYSTEM_STRING_SYSTEM_SEPERATOR[0]);//_CHAR);
	long i = 0;
	while(tokeniser->hasMoreTokens())
	{
		char *temp = tokeniser->getNextToken();
		FREE_ARRAY_POINTER(temp);
		i++;
	}
	return i;
}

//	===========================================================================
CString *CSystemString::getPathComponent(const long index)
{
	if ((index > 0) || index < this->getNumberOfPathComponents())
	{
		CStringTokeniser *tokeniser = new CStringTokeniser(CString(m_string), CSYSTEM_STRING_SYSTEM_SEPERATOR[0]);//_CHAR);
		long i = 0;
		while(tokeniser->hasMoreTokens())
		{
			if (i == index)
			{
				CString *str = new CString(tokeniser->getNextToken());
				// Add the seperator back on for the drive
				if (index == 0)
				{
					str->appendString(CSYSTEM_STRING_SYSTEM_SEPERATOR);
				}
				return str;
			}
			else
			{
				char *temp = tokeniser->getNextToken();
				FREE_ARRAY_POINTER(temp);
				i++;
			}
		}
	}
	return NULL;
}

//	===========================================================================
void CSystemString::removeLastPathComponent()
{
	// Find the index of the last character
	const long index = this->findBackwards(CSYSTEM_STRING_SYSTEM_SEPERATOR[0]) - 1;

	if (index > 0)
	{
		// Get the sub string
		this->setString(this->getSubString(0, index));
		//char *subString = this->getSubString(0, index);

		// CHeck we got a valid string
		//if (subString)
		//{
			// Set the new stirng
			//this->setString(subString);

			// Delete the sub string
			//FREE_ARRAY_POINTER(subString);
		//}
	}
}

//	===========================================================================
void CSystemString::removeFirstPathComponent()
{
	// Find the index of the last character
	const long index = this->findForward(CSYSTEM_STRING_SYSTEM_SEPERATOR[0]) + 1;

	if (index > 0)
	{
		// Get the sub string
		//char *subString = this->getSubString(index, m_numberOfCharacters);
		this->setString(this->getSubString(index, m_numberOfCharacters));

		// CHeck we got a valid string
		//if (subString)
		//{
			// Set the new stirng
		//	this->setString(subString);

			// Delete the sub string
		//	FREE_ARRAY_POINTER(subString);
		//}
	}
}

//	===========================================================================
void CSystemString::replacePathSeperators()
{
#ifdef WIN32
	this->replaceCharWithChar('/', '\\');
#else
	this->replaceCharWithChar('\\', '/');
#endif
}

#ifndef WIN32
//	===========================================================================
FSSpec *CSystemString::getStringAsFSSpec() const
{
	// Make a ConstStr255Param
	CPascalString str(this->getString());

	// The file spec that we are going to return
	FSSpec *string = new FSSpec;
	memset(string, 0, sizeof(FSSpec));

	// Create the string
	const OSErr error = FSMakeFSSpec(0, 0, str.getUnsignedConstString(), string);

	// Check the return code and return a valid result
	if (error == noErr || error == fnfErr)
	{
		return string;
	}
	else
	{
		FREE_POINTER(string);
		return NULL;
	}
}
//	===========================================================================
FSRef *CSystemString::getStringAsFSRef() const
{
	FSSpec *string = this->getStringAsFSSpec();
	
	if (string == NULL)
	{
		return NULL;
	}
	
	FSRef *fsRef   = new FSRef;
	OSErr error	   = FSpMakeFSRef(string, fsRef);

	FREE_POINTER(string);
	if (error == noErr)
	{
		return fsRef;
	}
	return NULL;
}
#endif